/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigIndexKeysRender;
import filenet.vw.toolkit.admin.property.base.VWConfigIndexPropertyDialog;
import filenet.vw.toolkit.admin.property.base.VWConfigIndexTableModel;
import filenet.vw.toolkit.admin.property.base.VWConfigStatusRender;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWConfigIndexPane
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private Frame m_parentFrame = null;
    private IVWTableDefinition m_tableDef = null;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_indexTable = null;
    private VWConfigIndexTableModel m_indexTableModel = null;

    public VWConfigIndexPane(Frame parent, IVWTableDefinition tableDef) {
        try {
            this.m_parentFrame = parent;
            this.m_tableDef = tableDef;
            this.createControls(VWResource.Indexes, 0x10000030);
            this.m_indexTable.clearSelection();
            if (this.m_indexTableModel.getRowCount() > 0) {
                this.m_indexTable.setRowSelectionInterval(0, 0);
            }
            VWConfigIndexTableMouse mouse = new VWConfigIndexTableMouse();
            this.m_indexTable.addMouseListener(mouse);
            this.m_indexTable.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isModified() {
        if (this.m_indexTableModel != null) {
            return this.m_indexTableModel.isModified();
        }
        return false;
    }

    public void stopEditing() {
        if (this.m_indexTable != null) {
            this.m_indexTable.stopEditing();
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_indexTable.getSelectedRow()) {
                    this.m_indexTable.clearSelection();
                }
                if (this.m_indexTable.getRowCount() <= 0) break;
                this.m_indexTable.setRowSelectionInterval(nRow, nRow);
                this.m_indexTable.ensureRowIsVisible(nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nFirstIndex = this.m_indexTable.getSelectionModel().getMinSelectionIndex();
            int nLastIndex = this.m_indexTable.getSelectionModel().getMaxSelectionIndex();
            if (nFirstIndex == -1 || nLastIndex == -1) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000020));
            } else {
                boolean bEnableDelete = true;
                for (int i = nFirstIndex; i <= nLastIndex; ++i) {
                    if (this.m_indexTableModel.getCanDeleteRow(i)) continue;
                    bEnableDelete = false;
                    break;
                }
                if (bEnableDelete) {
                    this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000020));
                } else {
                    this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000020));
                }
            }
        }
    }

    public void releaseResources() {
        this.m_parentFrame = null;
        this.m_tableDef = null;
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseResources();
            this.m_toolBarBorder = null;
        }
        if (this.m_indexTable != null) {
            this.m_indexTable.removeAll();
            this.m_indexTable = null;
        }
        if (this.m_indexTableModel != null) {
            this.m_indexTableModel.releaseResources();
            this.m_indexTableModel = null;
        }
        this.removeAll();
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.performNewIndex();
                    break;
                }
                case 32: {
                    this.performEditIndex();
                    break;
                }
                case 0x10000000: {
                    this.performDeleteIndex();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls(String description, int nFlags) {
        JPanel panel = null;
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 1;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.m_toolBarBorder = new VWToolbarBorder(description, nFlags);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.add((Component)this.m_toolBarBorder, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_toolBarBorder, this, description, description);
            this.createIndexTable();
            VWAccessibilityHelper.setAccessibility(this.m_indexTable, panel, VWResource.IndexTable, VWResource.IndexTable);
            JLabel label = new JLabel(description);
            VWAccessibilityHelper.setAccessibility(label, this, description, description);
            VWAccessibilityHelper.setLabelFor(label, this.m_indexTable);
            panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_indexTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createIndexTable() {
        int nColWidth = 0;
        try {
            this.m_indexTableModel = new VWConfigIndexTableModel(this.m_parentFrame, this.m_tableDef);
            this.m_indexTableModel.addTableModelListener(this);
            this.m_indexTable = new VWTable(this.m_indexTableModel);
            this.m_indexTable.setRowSelectionAllowed(true);
            this.m_indexTable.setColumnSelectionAllowed(false);
            this.m_indexTable.getSelectionModel().addListSelectionListener(this);
            this.m_indexTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_indexTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            TableColumn aColumn = this.m_indexTable.getColumn(this.m_indexTable.getColumnName(0));
            try {
                nColWidth = Integer.valueOf("20");
            }
            catch (Exception ex) {
                nColWidth = 20;
            }
            aColumn.setMaxWidth(nColWidth);
            aColumn.setCellRenderer(new VWConfigStatusRender(1));
            aColumn = this.m_indexTable.getColumn(this.m_indexTable.getColumnName(1));
            try {
                nColWidth = Integer.valueOf("120");
            }
            catch (Exception ex) {
                nColWidth = 120;
            }
            aColumn.setMinWidth(nColWidth);
            aColumn = this.m_indexTable.getColumn(this.m_indexTable.getColumnName(2));
            try {
                nColWidth = Integer.valueOf("200");
            }
            catch (Exception ex) {
                nColWidth = 200;
            }
            aColumn.setMinWidth(nColWidth);
            aColumn.setCellRenderer(new VWConfigIndexKeysRender());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performNewIndex() {
        try {
            VWConfigIndexPropertyDialog indexProperty = new VWConfigIndexPropertyDialog(this.m_parentFrame, this.m_tableDef, null);
            indexProperty.setVisible(true);
            if (indexProperty.getReturnStatus() == 0) {
                this.m_indexTableModel.addItem(indexProperty.getUpdatedIndex());
            }
            indexProperty.releaseResources();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performDeleteIndex() {
        VWIndexDefinition indexDef = null;
        boolean bYesToAll = false;
        try {
            int[] rows = this.m_indexTable.getSelectedRows();
            for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                indexDef = this.m_indexTableModel.getIndexItemAt(rows[nIndex]);
                if (indexDef == null) continue;
                if (indexDef.isSystemIndex()) {
                    JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.CanNotDeleteSystemIndex.toString(indexDef.getName()), null, 1);
                    continue;
                }
                int ret = 0;
                if (!bYesToAll) {
                    Object[] options1 = new Object[]{VWResource.Yes, VWResource.YesToAll, VWResource.No};
                    ret = JOptionPane.showOptionDialog(this, VWResource.ConfirmDeleteIndex.toString(indexDef.getName()), null, -1, 3, null, options1, options1[1]);
                    if (ret == 1) {
                        bYesToAll = true;
                    }
                }
                if (ret != 0 && !bYesToAll) continue;
                this.m_indexTableModel.deleteItem(rows[nIndex]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performEditIndex() {
        try {
            int nRowIndex = this.m_indexTable.getSelectedRow();
            if (nRowIndex < 0) {
                return;
            }
            VWIndexDefinition indexDef = this.m_indexTableModel.getIndexItemAt(nRowIndex);
            if (indexDef == null) {
                return;
            }
            if (indexDef.isSystemIndex() || indexDef.isMandatorySystemIndex()) {
                JOptionPane.showMessageDialog(null, VWResource.CanNotEditSystemIndex, null, 1, null);
                return;
            }
            VWConfigIndexPropertyDialog indexProperty = new VWConfigIndexPropertyDialog(this.m_parentFrame, this.m_tableDef, indexDef);
            indexProperty.setVisible(true);
            if (indexProperty.getReturnStatus() == 0) {
                this.m_indexTableModel.updateItem(nRowIndex, indexProperty.getUpdatedIndex());
            }
            indexProperty.releaseResources();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private class VWConfigIndexTableMouse
    extends MouseAdapter {
        private VWConfigIndexTableMouse() {
        }

        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                VWConfigIndexPane.this.performEditIndex();
            }
        }
    }
}

